package gov.va.med.mhv.usermgmt.persist.ldap;

import netscape.ldap.LDAPConnection;

import org.apache.commons.pool.BasePoolableObjectFactory;

/**
 * Connection factory for directory server connection instances to support pooling.
 *
 * @author Jon Crater Apr 7, 2006 8:25:06 AM
 */
public class LdapPoolableConnectionFactory extends BasePoolableObjectFactory {

	public Object makeObject() throws Exception {
		return LdapUtil.createConnection();
	}

	public void destroyObject(Object o) throws Exception {
		LdapUtil.destroyConnection((LDAPConnection)o);
	}

	public boolean validateObject(Object o) {
		return o != null && ((LDAPConnection)o).isConnected();
	}
}
